-- File is True Dual Port RAM with dual clock for DRAM and ROM
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- ===================================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- ===================================================================
ENTITY dpram4Kx32 IS
PORT (clk_a  : IN STD_LOGIC; -- System clock DRAM
      clk_b  : IN STD_LOGIC; -- System clock PROM
      addr_a : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Data mem. address
      addr_b : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Prog. mem. address
      data_a : IN STD_LOGIC_VECTOR(31 DOWNTO 0); -- Data in for DRAM 
      we_a   : IN STD_LOGIC := '0'; -- Write only DRAM
      q_a    : OUT STD_LOGIC_VECTOR(31 DOWNTO 0); -- DRAM output
      q_b    : OUT STD_LOGIC_VECTOR(31 DOWNTO 0)); -- ROM output
END ENTITY dpram4Kx32;
-- ===================================================================
ARCHITECTURE fpga OF dpram4Kx32 IS

-- Build a 2-D array type for the RAM
TYPE MEM IS ARRAY(0 TO 4095) of STD_LOGIC_VECTOR(31 DOWNTO 0);
 
-- Define RAM and initial values
SHARED VARIABLE dram : MEM  := (
X"E51F_D000", --0:_start:  ldr     sp, [pc, #0]    /* initial stack pointer */
--X"EA00_000D", --4:         b       main            /* start @ main */
X"EA00_00A1", --4:         b       main            /* start @ main with dummy ops */
X"3FFF_FFEC", --8: .word 0x3fffffec                /* constant */
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",      
X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000",X"E320F000", 
X"E281_1001", --C: level3: add     r1, r1, #1      /* s1=s1+1 */
X"E580_100C", --10:        str     r1, [r0, #12]   /* array[3] = s1 */
X"E12F_FF1E", --14:        bx      lr              /* level3 ends */
X"E92D_4008", --18:level2: pushA1  {lr}            /* save the return address */       
X"E1A0_1081", --1C         addi    r1, r1, r1      /* s1=s1+s1 */
X"E580_1008", --20:        stw     r1, [r0, #8]    /* array[2] = s1 */
X"EBFF_FFF8", --24:        bl      <level3>
X"E8BD_8004", --28:        popA1   {r3,pc}         /* level2 ends */
X"E92D_4008", --2C:level1: pushA1  {r3,lr}         /* save the return address */       
X"E281_1001", --30:        add     r5, r5, #1      /* s1=s1+1 */
X"E580_1004", --34:        str     r1, [r0, #4]    /* array[1] = s1 */
X"EBFF_FFF6", --38:        bl      <level2>       
X"E8BD_8008", --3C         popA1   {r3,pc}         /* level1 ends */
X"E52D_E004", --40:main:   pushA2  {lr}             /* put lr in memory */
X"E24D_D03C", --44:        sub     sp, sp, #60      /* make space on sp */
X"E301_3233", --48:        movw    r3, #4659        /* s1=0x1233 */        
X"E58D_3034", --4C:        str     r3, [sp, #52]    /* save s1 */
X"E59D_1034", --50:loop:   ldr     r1, [sp, #52]
X"E1A0_000D", --54:        mov     r0, sp
X"EBFF_FFF3", --58:        bl      <level1> 
X"E59D_3004", --5C:        ldr     r3, [sp, #4]      /* s1 = array[1] */
X"E58D_3034", --60:        str     r3, [sp, #52]
X"E59D_3008", --64:        ldr     r3, [sp, #8]      /* s2 = array[2] */
X"E58D_3030", --68:        str     r3, [sp, #48]
X"E59D_300C", --6C:        ldr     r3, [sp, #12]     /* s3 = array[3] */
X"E58D_302C", --70:        str     r3, [sp, #44]
X"EAFF_FFF5", --74:        br      <loop>            /* start loop again */
OTHERS => "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"); -- Default unknown mem
--OTHERS => X"E320F000"); -- default NOP

BEGIN

  -- Port A aka DRAM
  PROCESS(clk_a)
  BEGIN
    IF(RISING_EDGE(clk_a)) THEN 
      IF(we_a = '1') THEN
        dram(CONV_INTEGER('0'& addr_a)) := data_a;
        q_a <= data_a;
      ELSE
        q_a <= dram(CONV_INTEGER('0'& addr_a));
      END IF;
    END IF;
  END PROCESS;

  -- Port B aka ROM
  PROCESS(clk_b)
  BEGIN
    IF(RISING_EDGE(clk_b)) THEN 
      q_b <= dram(CONV_INTEGER('0' & addr_b));
    END IF;
  END PROCESS;
  
END fpga;
